%------------------------------------------------------------------------------
% File     : SYO008^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Syntactic
% Problem  : The non-trivial direction of functional extensionality
% Version  : Especial.
% English  :

% Refs     : [BB05]  Benzmueller & Brown (2005), A Structured Set of Higher
%          : [Ben09] Benzmueller (2009), Email to Geoff Sutcliffe
% Source   : [Ben09]
% Names    : Example 11 [BB05]

% Status   : Theorem
%          : Without functional extensionality : CounterSatisfiable
% Rating   : 0.29 v7.4.0, 0.00 v7.1.0, 0.12 v7.0.0, 0.00 v6.2.0, 0.29 v6.0.0, 0.43 v5.5.0, 0.50 v5.4.0, 0.40 v5.3.0, 0.60 v4.1.0, 0.67 v4.0.1, 1.00 v3.7.0
% Syntax   : Number of formulae    :    5 (   0 unit;   2 type;   2 defn)
%            Number of atoms       :   20 (   2 equality;  14 variable)
%            Maximal formula depth :    8 (   6 average)
%            Number of connectives :   13 (   0   ~;   0   |;   0   &;  10   @)
%                                         (   0 <=>;   3  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   13 (  13   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    4 (   2   :;   0   =)
%            Number of variables   :    9 (   0 sgn;   5   !;   0   ?;   4   ^)
%                                         (   9   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
thf(leibeq1_type,type,(
    leibeq1: $i > $i > $o )).

thf(leibeq1,definition,
    ( leibeq1
    = ( ^ [U: $i,V: $i] :
        ! [Q: $i > $o] :
          ( ( Q @ U )
         => ( Q @ V ) ) ) )).

thf(leibeq2_type,type,(
    leibeq2: ( $i > $i ) > ( $i > $i ) > $o )).

thf(leibeq2,definition,
    ( leibeq2
    = ( ^ [X: $i > $i,Y: $i > $i] :
        ! [P: ( $i > $i ) > $o] :
          ( ( P @ X )
         => ( P @ Y ) ) ) )).

thf(conj,conjecture,(
    ! [F: $i > $i,G: $i > $i] :
      ( ! [X: $i] :
          ( leibeq1 @ ( F @ X ) @ ( G @ X ) )
     => ( leibeq2 @ F @ G ) ) )).

%------------------------------------------------------------------------------
